/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream.buffer;

import com.sun.xml.internal.stream.buffer.AbstractCreatorProcessor;
import com.sun.xml.internal.stream.buffer.FragmentedArray;
import com.sun.xml.internal.stream.buffer.MutableXMLStreamBuffer;

public class AbstractCreator
extends AbstractCreatorProcessor {
    protected MutableXMLStreamBuffer _buffer;

    public void setXMLStreamBuffer(MutableXMLStreamBuffer mutableXMLStreamBuffer) {
        if (mutableXMLStreamBuffer == null) {
            throw new NullPointerException("buffer cannot be null");
        }
        this.setBuffer(mutableXMLStreamBuffer);
    }

    public MutableXMLStreamBuffer getXMLStreamBuffer() {
        return this._buffer;
    }

    protected final void createBuffer() {
        this.setBuffer(new MutableXMLStreamBuffer());
    }

    protected final void increaseTreeCount() {
        ++this._buffer.treeCount;
    }

    protected final void setBuffer(MutableXMLStreamBuffer mutableXMLStreamBuffer) {
        this._buffer = mutableXMLStreamBuffer;
        this._currentStructureFragment = this._buffer.getStructure();
        this._structure = (byte[])this._currentStructureFragment.getArray();
        this._structurePtr = 0;
        this._currentStructureStringFragment = this._buffer.getStructureStrings();
        this._structureStrings = (String[])this._currentStructureStringFragment.getArray();
        this._structureStringsPtr = 0;
        this._currentContentCharactersBufferFragment = this._buffer.getContentCharactersBuffer();
        this._contentCharactersBuffer = (char[])this._currentContentCharactersBufferFragment.getArray();
        this._contentCharactersBufferPtr = 0;
        this._currentContentObjectFragment = this._buffer.getContentObjects();
        this._contentObjects = (Object[])this._currentContentObjectFragment.getArray();
        this._contentObjectsPtr = 0;
    }

    protected final void setHasInternedStrings(boolean bl) {
        this._buffer.setHasInternedStrings(bl);
    }

    protected final void storeStructure(int n) {
        this._structure[this._structurePtr++] = (byte)n;
        if (this._structurePtr == this._structure.length) {
            this.resizeStructure();
        }
    }

    protected final void resizeStructure() {
        this._structurePtr = 0;
        if (this._currentStructureFragment.getNext() != null) {
            this._currentStructureFragment = this._currentStructureFragment.getNext();
            this._structure = (byte[])this._currentStructureFragment.getArray();
        } else {
            this._structure = new byte[this._structure.length];
            this._currentStructureFragment = new FragmentedArray<byte[]>(this._structure, this._currentStructureFragment);
        }
    }

    protected final void storeStructureString(String string) {
        this._structureStrings[this._structureStringsPtr++] = string;
        if (this._structureStringsPtr == this._structureStrings.length) {
            this.resizeStructureStrings();
        }
    }

    protected final void resizeStructureStrings() {
        this._structureStringsPtr = 0;
        if (this._currentStructureStringFragment.getNext() != null) {
            this._currentStructureStringFragment = this._currentStructureStringFragment.getNext();
            this._structureStrings = (String[])this._currentStructureStringFragment.getArray();
        } else {
            this._structureStrings = new String[this._structureStrings.length];
            this._currentStructureStringFragment = new FragmentedArray<String[]>(this._structureStrings, this._currentStructureStringFragment);
        }
    }

    protected final void storeContentString(String string) {
        this.storeContentObject(string);
    }

    protected final void storeContentCharacters(int n, char[] cArray, int n2, int n3) {
        if (this._contentCharactersBufferPtr + n3 >= this._contentCharactersBuffer.length) {
            if (n3 >= 512) {
                this.storeStructure(n | 4);
                this.storeContentCharactersCopy(cArray, n2, n3);
                return;
            }
            this.resizeContentCharacters();
        }
        if (n3 < 256) {
            this.storeStructure(n);
            this.storeStructure(n3);
            System.arraycopy(cArray, n2, this._contentCharactersBuffer, this._contentCharactersBufferPtr, n3);
            this._contentCharactersBufferPtr += n3;
        } else if (n3 < 65536) {
            this.storeStructure(n | 1);
            this.storeStructure(n3 >> 8);
            this.storeStructure(n3 & 0xFF);
            System.arraycopy(cArray, n2, this._contentCharactersBuffer, this._contentCharactersBufferPtr, n3);
            this._contentCharactersBufferPtr += n3;
        } else {
            this.storeStructure(n | 4);
            this.storeContentCharactersCopy(cArray, n2, n3);
        }
    }

    protected final void resizeContentCharacters() {
        this._contentCharactersBufferPtr = 0;
        if (this._currentContentCharactersBufferFragment.getNext() != null) {
            this._currentContentCharactersBufferFragment = this._currentContentCharactersBufferFragment.getNext();
            this._contentCharactersBuffer = (char[])this._currentContentCharactersBufferFragment.getArray();
        } else {
            this._contentCharactersBuffer = new char[this._contentCharactersBuffer.length];
            this._currentContentCharactersBufferFragment = new FragmentedArray<char[]>(this._contentCharactersBuffer, this._currentContentCharactersBufferFragment);
        }
    }

    protected final void storeContentCharactersCopy(char[] cArray, int n, int n2) {
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        this.storeContentObject(cArray2);
    }

    protected final Object peekAtContentObject() {
        return this._contentObjects[this._contentObjectsPtr];
    }

    protected final void storeContentObject(Object object) {
        this._contentObjects[this._contentObjectsPtr++] = object;
        if (this._contentObjectsPtr == this._contentObjects.length) {
            this.resizeContentObjects();
        }
    }

    protected final void resizeContentObjects() {
        this._contentObjectsPtr = 0;
        if (this._currentContentObjectFragment.getNext() != null) {
            this._currentContentObjectFragment = this._currentContentObjectFragment.getNext();
            this._contentObjects = (Object[])this._currentContentObjectFragment.getArray();
        } else {
            this._contentObjects = new Object[this._contentObjects.length];
            this._currentContentObjectFragment = new FragmentedArray<Object[]>(this._contentObjects, this._currentContentObjectFragment);
        }
    }
}

