/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.ws.spi;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.ws.WebServiceException;

class FactoryFinder {
    private static final String OSGI_SERVICE_LOADER_CLASS_NAME = "com.sun.org.glassfish.hk2.osgiresourcelocator.ServiceLoader";

    FactoryFinder() {
    }

    private static Object newInstance(String string, ClassLoader classLoader) {
        try {
            Class clazz = FactoryFinder.safeLoadClass(string, classLoader);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WebServiceException("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new WebServiceException("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static Object find(String string, String string2) {
        String string3;
        InputStream inputStream;
        BufferedReader bufferedReader;
        ClassLoader classLoader;
        block17: {
            Object object;
            if (FactoryFinder.isOsgi()) {
                return FactoryFinder.lookupUsingOSGiServiceLoader(string);
            }
            try {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            catch (Exception exception) {
                throw new WebServiceException(exception.toString(), exception);
            }
            String string4 = "META-INF/services/" + string;
            bufferedReader = null;
            try {
                inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string4) : classLoader.getResourceAsStream(string4);
                if (inputStream == null || (string3 = (bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"))).readLine()) == null || "".equals(string3)) break block17;
                object = FactoryFinder.newInstance(string3, classLoader);
            }
            catch (Exception exception) {
                FactoryFinder.close(bufferedReader);
                catch (Throwable throwable) {
                    FactoryFinder.close(bufferedReader);
                    throw throwable;
                }
            }
            FactoryFinder.close(bufferedReader);
            return object;
        }
        FactoryFinder.close(bufferedReader);
        inputStream = null;
        try {
            string3 = System.getProperty("java.home");
            String string5 = string3 + File.separator + "lib" + File.separator + "jaxws.properties";
            File file = new File(string5);
            if (file.exists()) {
                Properties properties = new Properties();
                inputStream = new FileInputStream(file);
                properties.load(inputStream);
                String string6 = properties.getProperty(string);
                Object object = FactoryFinder.newInstance(string6, classLoader);
                return object;
            }
        }
        catch (Exception exception) {
        }
        finally {
            FactoryFinder.close(inputStream);
        }
        try {
            string3 = System.getProperty(string);
            if (string3 != null) {
                return FactoryFinder.newInstance(string3, classLoader);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string2 == null) {
            throw new WebServiceException("Provider for " + string + " cannot be found", null);
        }
        return FactoryFinder.newInstance(string2, classLoader);
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static Class safeLoadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            int n;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && (n = string.lastIndexOf(46)) != -1) {
                securityManager.checkPackageAccess(string.substring(0, n));
            }
            if (classLoader == null) {
                return Class.forName(string);
            }
            return classLoader.loadClass(string);
        }
        catch (SecurityException securityException) {
            if ("com.sun.xml.internal.ws.spi.ProviderImpl".equals(string)) {
                return Class.forName(string);
            }
            throw securityException;
        }
    }

    private static boolean isOsgi() {
        try {
            Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static Object lookupUsingOSGiServiceLoader(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{clazz};
            Class<?> clazz2 = Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME);
            Method method = clazz2.getMethod("lookupProviderInstances", Class.class);
            Iterator iterator = ((Iterable)method.invoke(null, classArray)).iterator();
            return iterator.hasNext() ? iterator.next() : null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

